#!/bin/bash
export datasets1="Cora CiteSeer PubMed cs wikics"
export datasets2="physics OGBN-Arxiv"
export missing_rates="0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.99 0.99 0.999 0.9999 1.0"
export lambda_list_1="0.00001"
export lambda_list_2="0.00001 0.0001 0.001 0.01 0.1 1 10"
export lp_alpha_list="0.9 0.99 0.999 0.9999"
export embedders="GNN"
export embedder_lp_list="GCN_LPA Correct_Smooth"
export attn_type="random sum mean concat"
export gpu=2



for missing_rate in $missing_rates
do
python main.py --dataset Cora --lp_alpha 0.99 --lamb 0.0 --missing_rate ${missing_rate} --embedder GOODIE_attn --attn_type ${attn_type} --n_runs 1 --missing_type uniform --gpu ${gpu}
python main.py --dataset Cora --lp_alpha 0.99 --lamb 0.0 --missing_rate ${missing_rate} --embedder GOODIE_attn --attn_type ${attn_type} --n_runs 1 --missing_type structural --gpu ${gpu}
done

for missing_rate in $missing_rates
do
python main.py --dataset CiteSeer --lp_alpha 0.999 --lamb 0.0 --missing_rate ${missing_rate} --embedder GOODIE_attn --attn_type ${attn_type} --n_runs 1 --missing_type uniform --gpu ${gpu}
python main.py --dataset CiteSeer --lp_alpha 0.999 --lamb 0.0 --missing_rate ${missing_rate} --embedder GOODIE_attn --attn_type ${attn_type} --n_runs 1 --missing_type structural --gpu ${gpu}
done

for missing_rate in $missing_rates
do
python main.py --dataset wikics --lp_alpha 0.9 --lamb 0.0 --missing_rate ${missing_rate} --embedder GOODIE_attn --attn_type ${attn_type} --n_runs 1 --missing_type uniform --gpu ${gpu}
python main.py --dataset wikics --lp_alpha 0.9 --lamb 0.0 --missing_rate ${missing_rate} --embedder GOODIE_attn --attn_type ${attn_type} --n_runs 1 --missing_type structural --gpu ${gpu}
done

for missing_rate in $missing_rates
do
python main.py --dataset cs --lp_alpha 0.99 --lamb 0.0 --missing_rate ${missing_rate} --embedder GOODIE_attn --attn_type ${attn_type} --n_runs 1 --missing_type uniform --gpu ${gpu}
python main.py --dataset cs --lp_alpha 0.99 --lamb 0.0 --missing_rate ${missing_rate} --embedder GOODIE_attn --attn_type ${attn_type} --n_runs 1 --missing_type structural --gpu ${gpu}
done

for missing_rate in $missing_rates
do
python main.py --dataset physics --lp_alpha 0.999 --lamb 0.0 --missing_rate ${missing_rate} --embedder GOODIE_2_attn --attn_type ${attn_type} --n_runs 1 --missing_type uniform --gpu ${gpu}
python main.py --dataset physics --lp_alpha 0.999 --lamb 0.0 --missing_rate ${missing_rate} --embedder GOODIE_2_attn --attn_type ${attn_type} --n_runs 1 --missing_type structural --gpu ${gpu}
done

for missing_rate in $missing_rates
do
python main.py --dataset OGBN-Arxiv --lp_alpha 0.8 --lamb 0.0 --missing_rate ${missing_rate} --embedder GOODIE_2_attn --attn_type ${attn_type} --n_runs 1 --missing_type uniform --gpu ${gpu}
python main.py --dataset OGBN-Arxiv --lp_alpha 0.8 --lamb 0.0 --missing_rate ${missing_rate} --embedder GOODIE_2_attn --attn_type ${attn_type} --n_runs 1 --missing_type structural --gpu ${gpu}
done

for missing_rate in $missing_rates
do
python main.py --dataset PubMed --lp_alpha 0.999 --lamb 0.0 --missing_rate ${missing_rate} --embedder GOODIE_attn --attn_type ${attn_type} --n_runs 1 --missing_type uniform --gpu ${gpu}
python main.py --dataset PubMed --lp_alpha 0.999 --lamb 0.0 --missing_rate ${missing_rate} --embedder GOODIE_attn --attn_type ${attn_type} --n_runs 1 --missing_type structural --gpu ${gpu}
done